/**
 * Created by lei.wang_1 on 2016/11/25.
 */
appModule.directive("replyComments", ['$translate', 'utils', function (translate, utils) {
    return {
        restrict: "E",
        transclude: true,
        template: `<ng-transclude></ng-transclude>
                 <div ng-repeat="comment in image.comments">
                    <reply-comment reply="reply" current-user="currentUser" comment="comment" delta="delta" add-to-comments="addComment(comment)" index="$index" remove-comment="removeComment(index,e)" image-size="imageSize"></reply-comment>
                 </div>`,
        scope: {
            image: "=",
            currentUser: "=",
            reply: "="
        },
        link: function ($scope, element) {
            var $img = element.find('.repliedImage');
            var $parent = element.parent();
            $scope.delta = {
                left: 0,
                top: 0
            };
            if ($img.length == 0) {
                return;
            }

            $img.on('load', function () {
                utils.applyScope($scope, function () {
                    $scope.imageSize = {
                        width: $img.width(),
                        height: $img.height()
                    };
                    $scope.delta = {
                        left: $parent.width() - $img.width(),
                        top: 0
                    }
                });
            });

            $img.on('click', function (e) {
                e.stopPropagation();
                $scope.removeUnsavedComment();
                if ($scope.reply.status != 0 || $scope.image.status || !$scope.image.showDenyPanel) {
                    return;
                }
                utils.applyScope($scope, function () {
                    $scope.createComment(e.offsetX / $scope.imageSize.width, e.offsetY / $scope.imageSize.height);
                });
            });

            $scope.createComment = function (left, top) {
                if (!$scope.canCreateComment) {
                    return;
                }
                if (!$scope.image.comments) {
                    $scope.image.comments = [];
                }
                $scope.closeInfo();
                $scope.image.comments.push({
                    left: left.toString(),
                    top: top.toString()
                });
            };

            $scope.removeComment = function (index, e) {
                if (e) {
                    e.stopPropagation();
                }
                if ($scope.image.comments[index]) {
                    $scope.image.comments.splice(index, 1);
                }
            };

            $scope.removeUnsavedComment = function () {
                if (!$scope.image.comments) {
                    return;
                }
                $scope.image.comments = $scope.image.comments.filter(function (comment) {
                    return !!comment.text
                });
            };

            $scope.closeInfo= function(comment){
                $scope.$broadcast('closeInfo',comment);
            };

            var stopWatchShowDenied = $scope.$watch('image.status', function (newV) {
                if (!!newV) {
                    $scope.canCreateComment = false;
                    if(newV == 1){
                        $scope.image.comments = [];
                    }
                } else {
                    $scope.canCreateComment = true;
                }
            });

            var onCommentClick = $scope.$on('commentClick',function(e,comment){
                $scope.$broadcast('closeInfo',comment);
            });

            $scope.$on('$destroy', function () {
                stopWatchShowDenied();
                onCommentClick();
            });
        }
    }
}]);

appModule.directive("replyComment", ['$translate', function (translate) {
    return {
        restrict: "E",
        template: `<div class="comment">
                    <div class="circle" ng-style="circleStyle" ng-bind="index + 1" ng-click="toggleInfo()"></div>
                    <div ng-show="isShowInfo">
                        <i class="arrow" ng-style="arrowStyle"></i>
                        <div class="commentInfo" ng-if="showText" ng-style="infoStyle">
                            <div class="inner">
                                    <div class="top">
                                    <div class="auditorInfo">
                                        <div class="avatar">
                                            <notice-image isrc="currentUser.avatar"></notice-image>
                                        </div>
                                        <div class="info">
                                            <div>
                                                <p class="name" ng-bind="currentUser.displayName"></p>
                                                <p class="orgInfo">
                                                    <span ng-bind="currentUser.departmentName"></span>
                                                    <span ng-bind="currentUser.position"></span>
                                                </p>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="optionBtn lightBtn" ng-show="reply.status == 0" ng-click="toggleOptionPanel()"></div>
                                    <ul class="optionPanel" ng-show="showOptionPanel">
                                        <li class="edit lightBtn" ng-click="showTextInfo($event)" translate="task.audit.edit-comment"></li>
                                        <li class="remove lightBtn" ng-click="removeComment({index:index,e:$event})" translate="task.audit.delete-comment"></li>
                                    </ul>
                                    
                                </div>
                                <pre ng-bind="comment.text" autoSize max-height="80" class="text"></pre>
                            </div>
                        </div>
                        <div class="commentInfo" ng-if="!showText" ng-style="infoStyle">
                            <div class="inner">
                                <div class="edit">
                                    <div contenteditable="plaintext-only" ng-style="inputStyle" div-input content="comment.text" placeholder="{{'task.audit.write-comment'|translate}}"></div>
                                    <button class="darkBtn" ng-click="save()" translate="common.complete"></button> 
                                </div>
                            </div>    
                        </div>
                    </div>
                  </div>`,
        scope: {
            comment: "=",
            index: "=",
            imageSize: "=",
            delta: "=",
            currentUser: "=",
            addToComments: "&",
            removeComment: "&",
            reply: "="
        },
        link: function ($scope,element) {
            var radius = 10;
            $scope.currentUser.avatar = $scope.currentUser.localAvatar || $scope.currentUser.remoteAvatarUrl;
            $scope.toggleInfo = function () {
                $scope.isShowInfo = !$scope.isShowInfo;
                $scope.showText = $scope.comment.text;
                $scope.$emit('commentClick',$scope.comment);
            };

            $scope.toggleOptionPanel = function () {
                $scope.showOptionPanel = !$scope.showOptionPanel;
            };

            $scope.save = function () {
                $scope.addToComments({comment: $scope.comment});
                $scope.isShowInfo = false;
            };

            $scope.showTextInfo = function (e) {
                e.stopPropagation();
                $scope.showOptionPanel = false;
                $scope.showText = false;
            };

            if (!$scope.comment.text) {
                $scope.isShowInfo = true;
                $scope.showText = false;
            }

            var stopWatchImageSize = $scope.$watch('imageSize', function (newV, oldV) {
                if (newV && newV.width && newV.height) {
                    var left = $scope.comment.left * $scope.imageSize.width - radius + $scope.delta.left;
                    var top = $scope.comment.top * $scope.imageSize.height - radius + $scope.delta.top;

                    $scope.circleStyle = {
                        left: left,
                        top: top,
                        width: radius * 2,
                        height: radius * 2,
                        'border-radius': radius,
                        'line-height': ((radius - 2) * 2) + 'px',
                        'font-size': radius + 'px'
                    };

                    $scope.infoStyle = {
                        left: left + radius * 2
                    };

                    var parentHeight = element.closest('.imageWrapper').height();

                    if(parentHeight - top >= 107){ //107= max-height of comment info - (initial height / 2)
                        $scope.infoStyle.top = top - radius;
                    }else{
                        $scope.infoStyle.bottom = parentHeight - top - 3*radius;
                    }

                    $scope.arrowStyle = {
                        left: left + radius * 2,
                        top: top + 3   //3 = (2 * radius - arrow height) / 2
                    };
                }
            });

            var offTopClick = $scope.$on('onTopElementClick', function (e, event) {
                if ($(event.target).closest('.circle').length > 0
                    || $(event.target).closest('.commentInfo').length > 0
                    || $(event.target).closest('.imageWrapper').length > 0
                ) {
                    return;
                }
                if (!$scope.comment.text) {
                    $scope.removeComment({index: $scope.index, e: event});
                }

                $scope.isShowInfo = false;
            });

            var closeInfo = $scope.$on('closeInfo',function(e,comment){
                if(comment && comment == $scope.comment){
                    return;
                }
                $scope.isShowInfo = false;
            });

            $scope.$on('$destroy', function () {
                offTopClick();
                stopWatchImageSize();
                closeInfo();
            });
        }
    };
}]);

appModule.directive("divInput", [function () {
    return {
        restrict: "A",
        scope: {
            content: "="
        },
        link: function ($scope, element) {

            element.on('input',function(){
                if(this.innerText != undefined){
                    $scope.content = this.innerText;
                }
            });

            var stopWatch = $scope.$watch('content', function (newVal) {
                if (newVal && newVal != element[0].innerText) {
                    element[0].innerText = newVal;
                }
            });

            $scope.$on('$destroy',function(){
                stopWatch();
            });
        }
    }
}]);